/*---------------------------------------------------------------------------*\

    FILE....: TTRANSFER.CPP
    TYPE....: C++ Console program
    AUTHOR..: David Rowe
    DATE....: 6/06/01

    This program tests transferring using hook flashes.

    1. Compile using 'make'
    2. connect a PBX line to port 1.
    3. Run this program with ./ttransfer TferNum
    4. Dial the number of the PBX line.
    5. This program will answer and then attempt to transfer to TferNum.

    Results:
    DR 6/6/01 - transfer worked OK on DSpace PBX

\*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*\

         Voicetronix Voice Processing Board (VPB) Software

         Copyright (C) 1999-2001 Voicetronix www.voicetronix.com.au

         This library is free software; you can redistribute it and/or
         modify it under the terms of the GNU Lesser General Public
         License as published by the Free Software Foundation; either
         version 2.1 of the License, or (at your option) any later version.

         This library is distributed in the hope that it will be useful,
         but WITHOUT ANY WARRANTY; without even the implied warranty of
         MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
         Lesser General Public License for more details.

         You should have received a copy of the GNU Lesser General Public
         License along with this library; if not, write to the Free Software
         Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
	 USA

\*---------------------------------------------------------------------------*/

#include <assert.h>
#include <stdlib.h>
#include <stdio.h>

#include "../src/vpbapi.h"
#include "../src/verbose.h"
#include "../src/mess.h"

int kbhit();

int main(int argc, char *argv[])
{
	int		h;
	VPB_EVENT	e;
	int	        ret;
	char		s[VPB_MAX_STR];

	if (argc != 3) {
		printf("usage: %s Port[1..] TransferNumber\n",argv[0]);
		exit(0);
	}

	//verbose(1);
	vpb_seterrormode(VPB_DEVELOPMENT);

	h = vpb_open(1,atoi(argv[1]));
	vpb_sethook_sync(h,VPB_ONHOOK);
	
	printf("Waiting for ring...please ring me!\n");

	do {
		ret = vpb_get_event_async(&e);
		if (ret == VPB_OK) {
			vpb_translate_event(&e, s);
			printf("%s",s);
		}
		vpb_sleep(100);

	} while(!kbhit() && (e.type != VPB_RING));

	vpb_sethook_sync(h,VPB_OFFHOOK);
	vpb_sleep(2000);

	char number[VPB_MAX_STR];
	sprintf(number, "&,%s",argv[2]);
	printf("dial string: %s\n",number);
	vpb_dial_sync(h, number);
	vpb_sleep(2000);
	vpb_sethook_sync(h,VPB_ONHOOK);

	vpb_close(h);

	return 0;
}


